function LPIV = doLPIV(LPIV)

yy      = LPIV.vars(LPIV.p+1:end,:);                    % outcome variables
YY      = LPIV.vars(LPIV.p+1:end,1);                    % endogenous regressor
XX      = lagmatrix(LPIV.vars,1:LPIV.p);
XX      = [XX(LPIV.p+1:end,:) LPIV.DET(LPIV.p+1:end,:)]; % controls
ZZ      = LPIV.taxshocks(LPIV.p+1:end,:);              % instruments

[LPIV.T,LPIV.n] = size(yy);
LPIV.k  = size(XX,2)+size(YY,2);

IRFs            = zeros(LPIV.irhor,LPIV.n);
IRFs_ols        = zeros(LPIV.irhor,LPIV.n);
LPIV.OmegaSTATA = zeros(2,2,LPIV.n,LPIV.irhor);
LPIV.gammah     = zeros(LPIV.irhor,LPIV.n);
LPIV.gamma1     = zeros(LPIV.irhor,1);

for h = 0:LPIV.irhor-1
y = yy((1+h):end, :); %y_{t+h}, t=1,...,T-h
Y = YY(1:(end-h), :); %Y_t      t=1,...,T-h
X = XX(1:(end-h), :); %X_t      t=1,...,T-h
    % omit RHS regressor without variability other than constant: 
    varX = var(X);
    X(:,[varX(:,1:end-1) 1]<eps)=[];
Z = ZZ(1:(end-h), :); %z_t      t=1,...,T-h

% Just-Identified IV
IVcoeffs     =         ([X';Z']*[X,Y])\([X';Z']*y);
OLScoeffs    =         ([X';Y']*[X,Y])\([X';Y']*y);
u           = Y-[X,Z]*(([X';Z']*[X,Z])\([X';Z']*Y)); 
e           = y-[X,Y]*IVcoeffs;

IRFs(1+h,:)     = IVcoeffs(end,:);  
IRFs_ols(1+h,:) = OLScoeffs(end,:);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Some Additional Statistics for Later Use
    XXp           = (X'*X)./(LPIV.T-h);
    ZXp           = (Z'*X)./(LPIV.T-h);
    A             = [ -ZXp/XXp, 1 , zeros(1,size(XXp,1)), 0 ; ...
                       zeros(1,size(XXp,1))   , 0 , -ZXp/XXp,1];

   
    M             = eye((LPIV.T-h))-X*((X'*X)\X');
    ZMZp          = (Z'*M*Z/(LPIV.T-h));
    Zu            = Z.*u;
    Xu            = X.*u;
    for n= 1:LPIV.n
    W     = ((LPIV.T-h)/((LPIV.T-h)-LPIV.k))*NW_hac_STATA([X.*e(:,n),Z.*e(:,n),Xu,Zu],LPIV.NWlags);
    LPIV.OmegaSTATA(:,:,n,1+h) = A*W*A'./(ZMZp^2);
    end
    LPIV.gamma1(1+h,:) = ZMZp\(Z'*M*Y./(LPIV.T-h));
end

scale              = -1;
LPIV.irs           = scale*IRFs;
LPIV.irs_ols       = scale*IRFs_ols;




